<?php
/*
 * Plugin Name: Uniquepay BD
 * Plugin URI: https://wordpress.org/plugins/UniquePay+bd
 * Description: This plugin allows your customers to pay with Bkash, Nagad, Rocket and all BD gateways via uniquepaybd
 * Author: techmicroofficial
 * Author URI: https://uniquepaybd.com
 * Version: 1.0.0
 * Requries at least: 5.2
 * Requries PHP: 7.2
  License: GPL v2 or later
  License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: uniquepaybd
 */
 
 /*
 * This action hook registers our PHP class as a WooCommerce payment gateway
 */

if(isset($_GET['success'])){
    $DB_HOST = constant("DB_HOST");
    $DB_USER = constant("DB_USER");
    $DB_PASS = constant("DB_PASSWORD");
    $DB_NAME = constant("DB_NAME");
    
    $sqlconn=mysqli_connect($DB_HOST,$DB_USER,$DB_PASS,$DB_NAME);
    
    $success = $_GET['success'];
    
    global $wpdb;
    global $table_prefix;
    
    $table_pre = $table_prefix.'posts';
    
    $transactionId = $_GET['transactionId'];
    $paymentAmount = $_GET['paymentAmount'];
    $paymentFee = $_GET['paymentFee'];

    $transaction_id_uniquepaybd = $transactionId;

    if ($_GET['p_type']=='bank') {
        $sql = "UPDATE $table_pre SET `post_status`='wc-on-hold' WHERE ID='$success'";
        if(mysqli_query($sqlconn,$sql)){
?>
            <script>
                location.href="../my-account/orders/";
            </script>
<?php
        }
    } elseif ($_GET['p_type']=='mobile') {
        $data   = array(
            "transaction_id"          => $transaction_id_uniquepaybd,
        );        
    
        $sql = "UPDATE $table_pre SET `post_status`='wc-processing' WHERE ID='$success'";
        if(mysqli_query($sqlconn,$sql)){
?>
            <script>
                location.href="../my-account/orders/";
            </script>
<?php
        }
    }
}

add_filter( 'woocommerce_payment_gateways', 'uniquepaybd_add_gateway_class' );
function uniquepaybd_add_gateway_class( $gateways ) {
    $gateways[] = 'WC_uniquepaybd_Gateway';
    return $gateways;
}

add_action( 'plugins_loaded', 'uniquepaybd_init_gateway_class' );
function uniquepaybd_init_gateway_class() {

    class WC_uniquepaybd_Gateway extends WC_Payment_Gateway {

        public function __construct() {

            $this->id = 'uniquepaybd';
            $this->icon = 'https://uniquepaybd.com/assets/images/website/logo.png';
            $this->has_fields = false;
            $this->method_title = 'Uniquepaybd';
            $this->method_description = 'Pay With Uniquepaybd';

            $this->supports = array(
                'products'
            );

            $this->init_form_fields();

            $this->init_settings();
            $this->title = $this->get_option( 'title' );
            $this->description = $this->get_option( 'description' );
            $this->enabled = $this->get_option( 'enabled' );

            add_action( 'woocommerce_update_options_payment_gateways_' . $this->id, array( $this, 'process_admin_options' ) );
            add_action('woocommerce_api_wc_gateway_' . $this->id, array($this, 'handle_webhook'));
        
        }

        public function init_form_fields(){

            $this->form_fields = array(
                'enabled' => array(
                    'title'       => 'Enable/Disable',
                    'label'       => 'Enable Uniquepaybd',
                    'type'        => 'checkbox',
                    'description' => '',
                    'default'     => 'no'
                ),
                'title' => array(
                    'title'       => 'Title',
                    'type'        => 'text',
                    'description' => 'This controls the title which the user sees during checkout.',
                    'default'     => 'Uniquepaybd Gateway',
                    'desc_tip'    => true,
                ),
                'description' => array(
                    'title'       => 'Description',
                    'type'        => 'textarea',
                    'description' => 'This controls the description which the user sees during checkout.',
                    'default'     => 'Pay With Uniquepaybd',
                ),
                'apikeys' => array(
                    'title'       => 'Enter Api Key',
                    'type'        => 'text',
                    'description' => '',
                    'default'     => '###################',
                    'desc_tip'    => true,
                ),
                'secretkey' => array(
                    'title'       => 'Enter Secret Key',
                    'type'        => 'text',
                    'description' => '',
                    'default'     => '#############',
                    'desc_tip'    => true,
                ),
                'hostname' => array(
                    'title'       => 'Enter Host Name',
                    'type'        => 'text',
                    'description' => '',
                    'default'     => 'uniquepaybd.com',
                    'desc_tip'    => true,
                ),
                'currency_rate' => array(
                    'title'       => 'Enter USD Rate',
                    'type'        => 'number',
                    'description' => '',
                    'default'     => '85',
                    'desc_tip'    => true,
                ),
                'payment_site' => array(
                    'title'       => 'Enter payment url',
                    'type'        => 'text',
                    'description' => '',
                    'default'     => 'https://pay.uniquepaybd.com',
                    'desc_tip'    => true,
                ),
                
            );
        }

        public function process_payment( $order_id ) {
            $order = wc_get_order( $order_id );

            global $woocommerce;
            $orders = new WC_Order($order_id);
            
            $current_user = wp_get_current_user();

            foreach ( $order->get_items() as $item_id => $item ) {
                $product_id = $item->get_product_id();
                $variation_id = $item->get_variation_id();
                $product = $item->get_product();
                $product_name = $item->get_name();
                $quantity = $item->get_quantity();
                $subtotal = $item->get_subtotal();
                $total = $item->get_total();
                $tax = $item->get_subtotal_tax();
                $tax_class = $item->get_tax_class();
                $tax_status = $item->get_tax_status();
                $allmeta = $item->get_meta_data();
                $somemeta = $item->get_meta( '_whatever', true );
                $item_type = $item->get_type();
            }

            $subtotal                = WC()->cart->subtotal;
            $shipping_total          = WC()->cart->get_shipping_total();
            $fees                    = WC()->cart->get_fee_total();
            $discount_excl_tax_total = WC()->cart->get_cart_discount_total();
            $discount_tax_total      = WC()->cart->get_cart_discount_tax_total();
                        
            $discount_total          = $discount_excl_tax_total + $discount_tax_total;
            $total = $subtotal + $shipping_total + $fees - $discount_total;

            if($order->get_currency() == 'USD'){
                $total = $total * $this->get_option('currency_rate');
            }

            if ($order->get_status() != 'completed') {
                $order->update_status('pending', __('Customer is being redirected to uniquepaybd', 'uniquepaybd'));
            }

            $data   = array(
                "cus_name"          => $current_user->user_firstname,
                "cus_email"         => $current_user->user_email,
                "amount"            => $total,
                "success_url"       => wc_get_page_permalink( 'checkout' ).'?success='.$order_id,
                "cancel_url"        => wc_get_page_permalink( 'checkout' ).'?cus_name='.$order_id.'&cus_email='.$current_user->user_email.'&done'
            );

            $header   = array(
                "api"               => $this->get_option('apikeys'),
                "secret"            => $this->get_option('secretkey'),
                "position"          => $this->get_option('hostname'),
                "url"               => $this->get_option('payment_site').'/request/payment/woocommerce',
            );
            $response = $this->create_payment($data, $header);
            $data = json_decode($response, true);

            return array(
                'result'    => 'success',
                'redirect'  => $data['payment_url']
            );
        }

        public function create_payment($data = "",$header='') {
            $headers = array(
                'Content-Type: application/x-www-form-urlencoded',
                'app-key: ' . $header['api'],
                'secret-key: ' . $header['secret'],
                'host-name: ' . $header['position'],
            );
            $url = $header['url'];
            $curl = curl_init();
            $data = http_build_query($data);
            
            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $data,
                CURLOPT_HTTPHEADER => $headers,
                CURLOPT_VERBOSE => true
            ));
             
            $response = curl_exec($curl);
            curl_close($curl);
            
            return $response;
        }       
        
    }
}
